﻿#include <iostream>
#include <cmath>
#include <algorithm>
#include <map>
#include <string>
#include <vector>
#include <set>
#include <unordered_map>
#include <unordered_set>
#include <numeric>
#include <stack>
#include <queue>
#include <deque>
#include <fstream>

using namespace std;

typedef long long ll;
typedef long double dl;

#define speed_up ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0)
#define endl "\n"

const ll INF = 1e18;

ifstream fin("a.in");
ofstream fout("a.out");

//#define cin fin
//#define cout fout

bool isPoly(ll n) {
    string s = to_string(n);
    string res = s;
    reverse(res.begin(), res.end());
    if (s == res) return true;
    return false;
}

unordered_map<ll, ll> mem;

ll dp(ll n) {
    ll um = mem[n];
    if (um > 0) return um;
    if (isPoly(n)) return 1;
    ll ans = INF;
    for (ll i = 1; i < n - 1; i++) {
        if (!isPoly(i)) continue;
        ll lans = dp(n - i);
        lans++;
        ans = min(ans, lans);
    }
    mem[n] = ans;
    return ans;
}

int main() {
    cout << fixed;
    cout.precision(10);
    speed_up;

    ll t; cin >> t;
    while (t--) {
        ll n; cin >> n;
        cout << dp(n) << endl;
    }
}